//computer play
public class Computer : IPlayer
{
    public IAction TakeTurn(Character character, Battle battle)
    {
        Thread.Sleep(500);
        List<Character> potentialTargets = FindTargets(character, battle);
        //if no targets, rest
        if (potentialTargets.Count == 0) return new RestAction(character);
        
        //random target attack (change to lowest HP target)
        Random random = new Random();
        Character target = potentialTargets[random.Next(potentialTargets.Count)];
        // attack pattern
        return new AttackAction (character, character.StandardAttack, target);
    }

    private static List<Character> FindTargets(Character character, Battle battle)
    {
        if (battle.Monsters.Characters.Contains(character))return battle.Heroes.Characters;
        else return battle.Monsters.Characters;
    }
}